package com.company.tp07_02_localtodoapp2.repository;

import android.app.Application;
import android.os.AsyncTask;

import androidx.annotation.NonNull;
import androidx.lifecycle.MutableLiveData;

import com.company.tp07_02_localtodoapp2.database.Todo;
import com.company.tp07_02_localtodoapp2.database.TodoDao;
import com.company.tp07_02_localtodoapp2.database.TodoRoomDatabase;

import java.util.List;

import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;


public class TodoRepo {
    private TodoDao todoDao;
    private MutableLiveData<List<Todo>> todoList;
    private static TodoRepo instance;

    public static TodoRepo getInstance(Application application){
        if(instance==null){
            instance = new TodoRepo(application);
        }
        return instance;
    }

    private TodoRepo(Application application) {
        TodoRoomDatabase db = TodoRoomDatabase.getInstance(application);
        todoDao = db.todoDao();
        todoList = new MutableLiveData<List<Todo>>();
        Observable<List<Todo>> observable = todoDao.getTodoList();
        Observer<List<Todo>> observer = new Observer<List<Todo>>() {
            @Override
            public void onSubscribe(@NonNull Disposable d) {
            }
            @Override
            public void onNext(@NonNull List<Todo> todos) {
                todoList.setValue(todos);
            }
            @Override
            public void onError(@NonNull Throwable e) {
            }
            @Override
            public void onComplete() {
            }
        };
        observable
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribeWith(observer);
    }
    public MutableLiveData<List<Todo>> getTodoList() {
        return todoList;
    }

    public void insert (Todo todo) {
        new insertAsyncTask(todoDao).execute(todo);
    }
    private static class insertAsyncTask extends AsyncTask<Todo, Void, Void> {

        private TodoDao mAsyncTodoDao;

        insertAsyncTask(TodoDao dao) {
            mAsyncTodoDao = dao;
        }
        @Override
        protected Void doInBackground(final Todo... params) {
            mAsyncTodoDao.insert(params[0]);
            return null;
        }
    }
}
